#
# ovirt-engine-setup -- ovirt engine setup
# Copyright (C) 2013 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


"""ovirt-host-remove core plugin."""


from otopi import util


from . import offlinepackager
from . import misc
from . import engine
from . import answerfile
from . import uninstall
from . import protocols
from . import postinstall


@util.export
def createPlugins(context):
    offlinepackager.Plugin(context=context)
    misc.Plugin(context=context)
    engine.Plugin(context=context)
    answerfile.Plugin(context=context)
    uninstall.Plugin(context=context)
    protocols.Plugin(context=context)
    postinstall.Plugin(context=context)


# vim: expandtab tabstop=4 shiftwidth=4
